//								EJEMPLO 4
//						Autor: Mikel Etxebarria
//			(c) Ingeniera de Microsistemas Programados S.L.
//						www.microcontroladores.com
//								Bilbao 2006
//
//Programa combinacional. Simulacin del control de una mquina de torneado
//
//La secuencia se inicia al pulsar "I" (RA0) que activa el cilindro "V" (RB0). Este en su
//avance empuja la pieza a tornear y acciona el sensor "b" (RA2) activando el rel del motor
//"M" (RB1). Comienza el torneado. Durante el avance se alcanza el sensor "c" (RA3) que 
//desactiva el cilindro "V" (RB0) inicindose el retroceso del mismo. Al volver a pasar 
//por "b" (RA2), se desconecta "M" (RB1). Cuando se alcanza el final de carrera "a" (RA1)
//se activa una seal acstica "A" RB2) para que el operario retire la pieza, coloque otra 
//nueva y, se inicie un nuevo ciclo, al pulsar "I" (RA0).

#include <16f876A.h>

//Ajusta los valores de la palabra de configuracin durante el ensamblaje:
//Proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

#fuses NOPROTECT,NOCPD,NOLVP,NOWDT,XT

// Con estas directivas las funciones "input" y "output_bit" no reprograman
// el pin de la puerta cada vez que son utilizadas. Si no se indica el
// modo fast_io se asume por defecto standard_io el cual reprograma el pin
// siempre antes de ser utilizadas estas funciones.

#use fast_io (A)
#use fast_io (B)

main()
{
  	output_b(0x0);					//Borra las salidas
	setup_adc_ports(NO_ANALOGS);	//Puerta A digital
  	set_tris_a(0x3F);				//Puerta A entrada
  	set_tris_b(0x00);				//Puerta B salida

	  while(1)
 	{   while(input(PIN_A0));
		output_low(PIN_B2);     // Desactivar seal acustica
    	output_high(PIN_B0);    // Activar cilindro "V"
		
		while(input(PIN_A2));	// Espera se active sensor b
		output_high(PIN_B1);	// Activa el motor M

		while(input(PIN_A3));	//Espera llegar al final de carrera c
		output_low(PIN_B0);		//Desactiva cilindro V

		while(input(PIN_A2));	//Espera retroceso hasta b
		output_low(PIN_B1);		//Desconecta el motor M

		while(input(PIN_A1));	//Espera llegar al final de carrera a
		output_high(PIN_B2);	//Activa acstico A
	}	
}

